<?php
include("../config.php");

if (PHP_SAPI == 'cli')
die('Este ejemplo sólo se puede ejecutar desde un navegador Web');
 
/** Incluye PHPExcel */
require_once 'lib/Classes/PHPExcel.php';
// Crear nuevo objeto PHPExcel
$objPHPExcel = new PHPExcel();
 
// Propiedades del documento
$objPHPExcel->getProperties()->setCreator("UDEP")
->setLastModifiedBy("UDEP")
->setTitle("Office 2010 XLSX UDEP")
->setSubject("Office 2010 XLSX UDEP")
->setDescription("Documento de prueba para Office 2010 XLSX, generado usando clases de PHP.")
->setKeywords("office 2010 openxml php")
->setCategory("seminario_internacional - UDEP");
 
 
 
// Combino las celdas desde A1 hasta E1
$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:E1');
 
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Seminario Internacional de Reputación Educativa - UDEP')
            ->setCellValue('A2', 'Nombre y Apellidos')
            ->setCellValue('B2', 'correo')
            ->setCellValue('C2', 'cargo')
            ->setCellValue('D2', 'colegio')
            ->setCellValue('E2', 'fecha_registro');
$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
 
$objPHPExcel->getActiveSheet()->getStyle('A1:E2')->applyFromArray($boldArray);
 
//Ancho de las columnas
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(60);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(60);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(40);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
 
$sql="SELECT * FROM 2018_seminario_internacional_udep_30_mayo  order by id";
$query=mysqli_query($con,$sql);
$cel=3;//Numero de fila donde empezara a crear  el 2018_seminario_internacional_udep_30_mayo
while ($row=mysqli_fetch_array($query)){
$director_nombre=$row['director_nombre'];
$director_correo=$row['director_correo'];
$cargo=$row['cargo'];
$colegio=$row['colegio'];
$fecha_registro=$row['fecha_registro'];
$a="A".$cel;
$b="B".$cel;
$c="C".$cel;
$d="D".$cel;
$e="E".$cel;

// Agregar datos
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue($a, $director_nombre)
            ->setCellValue($b, $director_correo)
            ->setCellValue($c, $cargo)
            ->setCellValue($d, $colegio)
            ->setCellValue($e, $fecha_registro);
$cel+=1;
}
 
/*Fin extracion de datos MYSQL*/
$rango="A2:$e" ;
$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
);
$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);
// Cambiar el nombre de hoja de cálculo
$objPHPExcel->getActiveSheet()->setTitle('Seminario Internacional');
 
 
// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
$objPHPExcel->setActiveSheetIndex(0);
 
 
// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="seminario_internacional.xls"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');
 
// Si usted está sirviendo a IE a través de SSL , a continuación, puede ser necesaria la siguiente
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0
 
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
exit;